/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamAuth;
import com.codedisaster.steamworks.SteamAuthTicket;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamUserCallback;
import com.codedisaster.steamworks.SteamUserCallbackAdapter;
import java.nio.Buffer;

public class SteamUser
extends SteamInterface {
    public SteamUser(SteamUserCallback callback) {
        super(SteamAPI.getSteamUserPointer(), SteamUser.createCallback(new SteamUserCallbackAdapter(callback)));
    }

    public SteamID getSteamID() {
        return new SteamID(SteamUser.getSteamID(this.pointer));
    }

    public SteamAuthTicket getAuthSessionTicket(Buffer authTicket, int[] sizeInBytes) throws SteamException {
        if (!authTicket.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        int ticket = SteamUser.getAuthSessionTicket(this.pointer, authTicket, authTicket.capacity(), sizeInBytes);
        if ((long)ticket != 0L) {
            authTicket.limit(sizeInBytes[0]);
        }
        return new SteamAuthTicket(ticket);
    }

    public SteamAuth.BeginAuthSessionResult beginAuthSession(Buffer authTicket, SteamID steamID) throws SteamException {
        if (!authTicket.isDirect()) {
            throw new SteamException("Direct buffer required!");
        }
        int result = SteamUser.beginAuthSession(this.pointer, authTicket, authTicket.limit(), steamID.handle);
        return SteamAuth.BeginAuthSessionResult.byOrdinal(result);
    }

    public void endAuthSession(SteamID steamID) {
        SteamUser.endAuthSession(this.pointer, steamID.handle);
    }

    public void cancelAuthTicket(SteamAuthTicket authTicket) {
        SteamUser.cancelAuthTicket(this.pointer, (int)authTicket.handle);
    }

    public SteamAuth.UserHasLicenseForAppResult userHasLicenseForApp(SteamID steamID, int appID) {
        return SteamAuth.UserHasLicenseForAppResult.byOrdinal(SteamUser.userHasLicenseForApp(this.pointer, steamID.handle, appID));
    }

    private static native long createCallback(SteamUserCallbackAdapter var0);

    private static native long getSteamID(long var0);

    private static native int getAuthSessionTicket(long var0, Buffer var2, int var3, int[] var4);

    private static native int beginAuthSession(long var0, Buffer var2, int var3, long var4);

    private static native void endAuthSession(long var0, long var2);

    private static native void cancelAuthTicket(long var0, int var2);

    private static native int userHasLicenseForApp(long var0, long var2, int var4);
}

